﻿var findRecode = {
    context: $(".v-find-recode"),
    datatable: null,
    initialize: function () {
        $(".h-browseQuestion").a4autocomplete({
            ajaxAction: a4.getProjectAction("GetBrowseQuestions", "Data"),
            altValueField: $("#QuestionNameSelected", findRecode.context),
            valueProperty: "Code",
            labelProperty: "Label",
            required: true,
            select: function (event, ui) {
                $(".replace", findRecode.context).prop("disabled", true).addClass("disabled");
            }
        });

        
    },
    initializeDataTable: function (applyCodeSelectorParams) {
        findRecode.datatable = $(".h-answer-table", findRecode.context).a4datatable({
            ajaxAction: a4.getProjectAction("GetBrowseRecodeAnswers", "Data"),
            ajaxParams: applyCodeSelectorParams,
            defaultSort: { Column: "CaseId", Ascending: true },
            displayColumnSelector: false,
            displaySearchBox: false,
            columns: this.getColumns(),
            allowRowSelection: voxco.security.has('MODIFY'),
            displayLength: 10,
            draw: function (event, data) {
                var noRecords = (data.totalRecords == 0);
                $(".h-replaceCode").prop("disabled", true).addClass("disabled");
                $(".h-replaceAll").prop("disabled", noRecords).toggleClass("disabled", noRecords);

                if (noRecords == 0)
                    $("#Recode").val("");

                var isCaseResult = $("#QuestionNameSelected", findRecode.context).val() == "CaseResult";
                $(this).a4datatable("toggleColumns", ["Matrix", "Mention"], isCaseResult == false);
            },
            selectRow: function (evt, data) {
                var disabled = !data.isChecked && findRecode.datatable.a4datatable("getSelectedItems").length == 0;
                $(".h-replaceCode", findRecode.context).prop("disabled", disabled).toggleClass("disabled", disabled);
            }
        });
    },
    getColumns: function () {
        columns = [];

        var isCaseResult = $("#QuestionNameSelected", findRecode.context).val() == "CaseResult";

        columns = [
            { "Name": "Id", "Title": resources.Respondent, "Data": "Id", "HideInSelector": true },
            { "Name": "Matrix", "Title": resources.Matrix, "Data": "Matrix", "Type": "numeric", "Visible": !isCaseResult },
            { "Name": "Mention", "Title": resources.Mention, "Data": "Mention", "Type": "numeric", "Visible": !isCaseResult },
            { "Name": "Value", "Title": resources.Response, "Data": "Value", "Editable": true, "Type": "multiple", "Editable": "[Content]", "Delimiter": " " }
        ]

        return columns;
    },
    bindEvents: function () {
        findRecode.context.on("click", ".h-find", function () {
            $("#Recode", findRecode.context).val("");
            $(".replace", findRecode.context).prop("disabled", false).removeClass("disabled");
            var caseFilter = null;
            var browse = a4.parent().browse || null;
            var openEndCoding = a4.parent().openEndCoding || null;

            if (browse != null && browse.caseFilter != null)
            {
                caseFilter = browse.caseFilter;            
            }
            else if (openEndCoding != null && openEndCoding.caseFilter != null)
            {
                caseFilter = openEndCoding.caseFilter;
            }

            var applyCodeSelectorParams = {
                projectId: $("#ProjectId", findRecode.context).val(),
                questionName: $("#QuestionNameSelected", findRecode.context).val(),
                isCaseResult: $("#QuestionNameSelected", findRecode.context).val() == "CaseResult",
                findCode: $("#Find", findRecode.context).val(),
                replaceCode: $("#Recode", findRecode.context).val(),
                respondentCasesJSON: "",
                caseFilter: caseFilter
            };

            if (findRecode.datatable) {
                findRecode.datatable.a4datatable("option", "ajaxParams", applyCodeSelectorParams);
                findRecode.datatable.a4datatable("refresh");
            }
            else {
                findRecode.initializeDataTable(applyCodeSelectorParams);
            }

        });

        findRecode.context.on("click", ".h-replaceCode", function () {
            $(".replace", findRecode.context).prop("disabled", true).addClass("disabled");
            var rows = findRecode.datatable.a4datatable("getSelectedItems");
            var respondentCases = [];

            _.each(rows, function (row) {
                respondentCases.push({ CaseId: row.Id, Mention: row.Mention, Matrix: row.Matrix });
            });

            findRecode.applyRecode(false, respondentCases);
        });

        findRecode.context.on("click", ".h-replaceAll", function () {
            $(".replace", findRecode.context).prop("disabled", true).addClass("disabled");
            findRecode.applyRecode(true, "");
        });
        findRecode.context.on("change", ".h-browseQuestion", function () {
            $(".recalculateStratas", findRecode.context).toggle(false);
        });
    },
    applyRecode: function (ApplyToAllSelection, respondentCases) {
        var applyRecodeSelectorParams = {
            projectId: $("#ProjectId", findRecode.context).val(),
            questionName: $("#QuestionNameSelected", findRecode.context).val(),
            applyToAllSelection: ApplyToAllSelection,
            isCaseResult: $("#QuestionNameSelected", findRecode.context).val() == "CaseResult",
            findCode: $("#Find", findRecode.context).val(),
            replaceCode: $("#Recode", findRecode.context).val(),
            respondentCasesJSON: JSON.stringify(respondentCases),
            caseFilter: a4.parent().browse.caseFilter,
            iTotalRecord: findRecode.datatable.a4datatable("getTotalRecords")
        };
                
        var confirmResources = applyRecodeSelectorParams.applyToAllSelection ? confirmFindAndReplaceAllResources : confirmFindAndReplaceSelectionResources;

        modalDialog.showConfirmDialog(confirmResources, function () {

            a4.callServerMethod(a4.getProjectAction("ApplyBrowseRecode", "Data"), applyRecodeSelectorParams, function (result) {
                a4.showSuccessMessage(result.message);
                findRecode.refreshContent();
                $(".recalculateStratas", findRecode.context).toggle(result.needRecalculateQuota);
            }, function (error) {
                a4.showErrorMessage(error.responseJSON.Message);
                var rows = findRecode.datatable.a4datatable("getSelectedItems");
                var disabled = rows.length == 0;
                $(".h-replaceCode", findRecode.context).prop("disabled", disabled).toggleClass("disabled", disabled);
                $(".h-replaceAll", findRecode.context).removeClass("disabled").prop("disabled", false);
            });


        }, 250, 500, false, { "variable": applyRecodeSelectorParams.questionName, "findValue": applyRecodeSelectorParams.findCode != "" ? applyRecodeSelectorParams.findCode : resources.Empty, "replaceValue": applyRecodeSelectorParams.replaceCode != "" ? applyRecodeSelectorParams.replaceCode : resources.Empty, "count": respondentCases ? respondentCases.length : 0 });

        
    },
    refreshContent: function () {
        findRecode.datatable.a4datatable("refresh");
    }
};

$(document).ready(function () {
    if (findRecode.context.length > 0) {
        findRecode.initialize();
        findRecode.bindEvents();
    }
});